/*
 * Decompiled with CFR 0.152.
 */
package skf;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class SKF
extends MIDlet
implements CommandListener {
    private Form resultForm;
    private Form dataForm;
    private ChoiceGroup sexChoice;
    private TextField years;
    private TextField mass;
    private TextField bloodKreatin;
    private Command dataExit;
    private Command dataOk;
    private Command resultExit;
    private Command resultBack;
    private Alert alert;
    private TextField result;
    private String alertString = new String();

    public SKF() {
        this.initialize();
    }

    private String getResult(String years, String mass, String bloodKreatin) {
        float koef;
        switch (this.sexChoice.getSelectedIndex()) {
            case 0: {
                koef = 1.23f;
                break;
            }
            case 1: {
                koef = 1.05f;
                break;
            }
            default: {
                koef = 0.0f;
            }
        }
        int y = Integer.parseInt(years);
        int m = Integer.parseInt(mass);
        int b = Integer.parseInt(bloodKreatin);
        float result = koef * (float)((140 - y) * m) / (float)b;
        return String.valueOf(result);
    }

    private boolean checkData(String years, String mass, String bloodKreatin) {
        try {
            int y = Integer.parseInt(years);
            int m = Integer.parseInt(mass);
            int b = Integer.parseInt(bloodKreatin);
            if (b < 3001) {
                return true;
            }
            this.alertString = "\u041e\u0448\u0438\u0431\u043a\u0430! \u041a\u0440\u0435\u0430\u0442\u0438\u043d\u0438\u043d > 3000.";
            return false;
        }
        catch (NumberFormatException ex) {
            this.alertString = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u0432\u043e\u0434\u0435 \u0438\u0441\u0445\u043e\u0434\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445!";
            return false;
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.dataForm) {
            if (command == this.dataOk) {
                if (this.checkData(this.years.getString(), this.mass.getString(), this.bloodKreatin.getString())) {
                    this.get_result().setString(this.getResult(this.years.getString(), this.mass.getString(), this.bloodKreatin.getString()));
                    this.getDisplay().setCurrent((Displayable)this.get_resultForm());
                } else {
                    this.get_alert().setString(this.alertString);
                    this.getDisplay().setCurrent((Displayable)this.get_alert());
                }
            } else if (command == this.dataExit) {
                this.exitMIDlet();
            }
        } else if (displayable == this.resultForm) {
            if (command == this.resultBack) {
                this.getDisplay().setCurrent((Displayable)this.get_dataForm());
            } else if (command == this.resultExit) {
                this.exitMIDlet();
            }
        }
    }

    private void initialize() {
        this.getDisplay().setCurrent((Displayable)this.get_dataForm());
    }

    public Display getDisplay() {
        return Display.getDisplay((MIDlet)this);
    }

    public void exitMIDlet() {
        this.getDisplay().setCurrent(null);
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public Form get_resultForm() {
        if (this.resultForm == null) {
            this.resultForm = new Form(null, new Item[]{this.get_result()});
            this.resultForm.addCommand(this.get_resultExit());
            this.resultForm.addCommand(this.get_resultBack());
            this.resultForm.setCommandListener((CommandListener)this);
        }
        return this.resultForm;
    }

    public Form get_dataForm() {
        if (this.dataForm == null) {
            this.dataForm = new Form(null, new Item[]{this.get_sexChoice(), this.get_years(), this.get_mass(), this.get_bloodKreatin()});
            this.dataForm.addCommand(this.get_dataExit());
            this.dataForm.addCommand(this.get_dataOk());
            this.dataForm.setCommandListener((CommandListener)this);
        }
        return this.dataForm;
    }

    public ChoiceGroup get_sexChoice() {
        if (this.sexChoice == null) {
            this.sexChoice = new ChoiceGroup("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043e\u043b:", 1, new String[]{"\u041c\u0443\u0436\u0441\u043a\u043e\u0439", "\u0416\u0435\u043d\u0441\u043a\u0438\u0439"}, new Image[]{null, null});
            this.sexChoice.setSelectedFlags(new boolean[]{true, false});
        }
        return this.sexChoice;
    }

    public TextField get_years() {
        if (this.years == null) {
            this.years = new TextField("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0432\u043e\u0437\u0440\u0430\u0441\u0442 (\u0433):", null, 2, 2);
        }
        return this.years;
    }

    public TextField get_mass() {
        if (this.mass == null) {
            this.mass = new TextField("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0432\u0435\u0441 (\u043a\u0433):", null, 3, 2);
        }
        return this.mass;
    }

    public TextField get_bloodKreatin() {
        if (this.bloodKreatin == null) {
            this.bloodKreatin = new TextField("\u041a\u0440\u0435\u0430\u0442\u0438\u043d\u0438\u043d \u043a\u0440\u043e\u0432\u0438 (\u043c\u043a\u043c\u043e\u043b\u044c/\u043b):", null, 4, 2);
        }
        return this.bloodKreatin;
    }

    public Command get_dataExit() {
        if (this.dataExit == null) {
            this.dataExit = new Command("Exit", 7, 1);
        }
        return this.dataExit;
    }

    public Command get_dataOk() {
        if (this.dataOk == null) {
            this.dataOk = new Command("Ok", 4, 1);
        }
        return this.dataOk;
    }

    public Command get_resultExit() {
        if (this.resultExit == null) {
            this.resultExit = new Command("Exit", 7, 1);
        }
        return this.resultExit;
    }

    public Command get_resultBack() {
        if (this.resultBack == null) {
            this.resultBack = new Command("Back", 2, 1);
        }
        return this.resultBack;
    }

    public Alert get_alert() {
        if (this.alert == null) {
            this.alert = new Alert(null, "<Enter Text>", null, null);
            this.alert.setTimeout(-2);
        }
        return this.alert;
    }

    public TextField get_result() {
        if (this.result == null) {
            this.result = new TextField("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 (\u0421\u041a\u0424):", null, 120, 0);
        }
        return this.result;
    }

    public void startApp() {
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }
}

